def solve_query(a, k):
    n = len(a)
    
    # Ako su sve karte vec u ruci, vracamo njihovu sumu
    if k >= n:
        return sum(a)
    
    # Pocetne karte u ruci
    hand = a[:k]
    
    # Prolazimo kroz preostale karte u špilu
    for j in range(k, n):
        # Dodajemo novu kartu u ruku
        hand.append(a[j])
        
        # Pronalazimo koja karta se najcešce pojavljuje
        max_count = 0
        best_card = 0
        
        # Prolazimo kroz sve razlicite vrednosti u ruci
        for card_value in set(hand):
            # Brojimo koliko puta se ova karta pojavljuje
            count = hand.count(card_value)
            
            # Ažuriramo najbolju kartu ako:
            # 1. Ova karta se pojavljuje više puta, ILI
            # 2. Pojavljuje se isti broj puta, ali ima vecu vrednost
            if count > max_count or (count == max_count and card_value > best_card):
                max_count = count
                best_card = card_value
        
        # Uklanjamo sve instance te karte iz ruke
        hand = [card for card in hand if card != best_card]
    
    # Vracamo sumu preostalih karata
    return sum(hand)


# Citanje ulaza
n, q = map(int, input().split())
a = list(map(int, input().split()))

# Obrada upita
for _ in range(q):
    query = list(map(int, input().split()))
    
    if query[0] == 1:
        # Tip 1: Nadi minimalnu sumu
        k = query[1]
        result = solve_query(a, k)
        print(result)
    else:
        # Tip 2: Promeni vrednost karte
        x, y = query[1], query[2]
        a[x - 1] = y